/**
 * Valide les champs obligatoires ainsi que le recaptcha
 * @author Jean Saposhnikov 
 */

let oRequireds = document.querySelectorAll("[required]");
let oFormError= document.querySelector(".form-error");
let hp=document.querySelector("input[name='name']");
let oSubmit=document.querySelector("#button-submit");
let oForm=document.querySelector("form");
let recaptchaElement = document.querySelector(".g-recaptcha");
let langue = document.documentElement.lang;

oForm.addEventListener('submit', function(event) {
    event.preventDefault();  // Prevent default form submission

    // Check if reCAPTCHA is available and has a valid sitekey
    if (typeof grecaptcha !== "undefined" && recaptchaElement.getAttribute('data-sitekey')) {
        grecaptcha.execute();    // Trigger reCAPTCHA before validation
    } else {
        // Display error if reCAPTCHA is not functioning
        oFormError.innerHTML = "Il semble y avoir une problématique avec la validation du recaptcha. Veuillez réessayer.";
        oFormError.classList.add("message-error");
        return;
    }
});

function onSubmit(token) {
    validateFields(token);
}

/**
 * Fonction vérifiant si les champs obligatoires sont remplis et si le honeypot est vide
 */
function validateFields(token){
    let iErrors = 0;
    let sTelephone = document.querySelector("input[name='telephone']");
    /**
     * Pour chaque champs obligatoire, vérifie s'ils sont vides
    */
    for(let i = 0; i < oRequireds.length; i++){
        if(oRequireds[i].value == ""){
            iErrors++;
            oRequireds[i].classList.add("input-error");
        }
        else{
            oRequireds[i].classList.remove("input-error");
        }
    }

    if(iErrors > 0) {
        if(langue == "fr"){
            oFormError.innerHTML="- Veuillez remplir les champs requis (*) ";
        }
        else{
            oFormError.innerHTML="- Please fill in the required fields (*) ";
        }
        oFormError.classList.remove("message-error");
        oFormError.classList.add("fields-error");
        return; // Do not proceed further if there are errors
    }

    else{
        if(sTelephone.value != ""){
            let valeurTelephone = sTelephone.value.replace(/\D/g, ''); // remove non-digit characters
            let allowedAreaCodes = /^(514|438|450|579|819|873|263|354|468)/;
    
            if (!allowedAreaCodes.test(valeurTelephone)) {
                sTelephone.classList.add("input-error");
                if(langue == "fr"){
                    oFormError.innerHTML = "- Le numéro de téléphone doit commencer par un indicatif régional valide.";
                } else {
                    oFormError.innerHTML = "- The phone number must start with a valid area code.";
                }
                oFormError.classList.remove("message-error");
                oFormError.classList.add("fields-error");
                return;
            } else {
                sTelephone.classList.remove("input-error");
            }
        }

        oFormError.innerHTML="";
        oFormError.classList.remove("fields-error");
        /**
            * Vérifie si le honeypot est vide
        */
        if (hp != null && hp.value === "") {
            oSubmit.disabled = true;
            oSubmit.innerHTML = "...";
            oForm.submit();  // Submit the form if everything is validated
        }
        else{
            oFormError.innerHTML="Il semble y avoir une problématique avec la validation du recaptcha. Veuillez réessayer.";
            oFormError.classList.add("message-error");
            if (typeof grecaptcha !== "undefined") {
                grecaptcha.reset();  // Reset reCAPTCHA if it's available
            }
            return;
        }
    }
}